// Tile break.js

// For use with cutting bushes/grass/or rocks and the like.
// Also used for cutting enemies.
/*
	This is used to get the tile that is situated right
	underneath the player character.
*/
function GetPlayerTile(layer)
{
	var tile = GetTile(Player.x,Player.y,layer);
	return GetTileName(tile);
}

/*
	This tile object stores the data gatherd from tiles
	that are found in front or under the main player.
*/
function HotSpot(tile,x,y)
{
	this.tile = tile;
	this.x = x;
	this.y = y;
}

/*
	This returns an array of tiles that are situated in
	front of your character. These tiles are the ones that
	are used in the function for cutting. :/
	A very stupid way since I could have just made a hotspot
	that trails your sword and a check to see if a certain
	tile/enemy is underneath that hotspot. 
*/
function CreateHotSpots(l) // l is layer
{ // will return an array of tile objects
	var d = GetPersonValue("you","d");
	var px = (GetPersonX("you")-7)/16;
	var py = (GetPersonY("you")-7)/16;
	if (d == "north")
	{
		var t1 = new HotSpot(GetTile(px,py-1,l),px,py-1);
		var t2 = new HotSpot(GetTile(px+1,py,l),px+1,py);
		var t3 = new HotSpot(GetTile(px-1,py-1,l),px-1,py-1);
		var t4 = new HotSpot(GetTile(px+1,py-1,l),px+1,py-1);
		var t5 = new HotSpot(GetTile(px-1,py-2,l),px-1,py-2);
		var t6 = new HotSpot(GetTile(px,py-2,l),px,py-2);
		return [t1,t2,t3,t4,t5,t6];
	}
	if (d == "south")
	{
		var t1 = new HotSpot(GetTile(px,py+1,l),px,py+1);
		var t2 = new HotSpot(GetTile(px+1,py+1,l),px+1,py+1);
		var t3 = new HotSpot(GetTile(px-1,py,l),px-1,py);
		var t4 = new HotSpot(GetTile(px,py+2,l),px,py+2);
		var t5 = new HotSpot(GetTile(px+1,py+2,l),px+1,py+2);
		var t6 = new HotSpot(GetTile(px-1,py+1,l),px-1,py+1);
		return [t1,t2,t3,t4,t5,t6];
	}
	if (d == "east")
	{
		var t1 = new HotSpot(GetTile(px+1,py,l),px+1,py);
		var t2 = new HotSpot(GetTile(px+1,py-1,l),px+1,py-1);
		var t3 = new HotSpot(GetTile(px,py+1,l),px,py+1);
		var t4 = new HotSpot(GetTile(px+1,py+1,l),px+1,py+1);
		var t5 = new HotSpot(GetTile(px+2,py-1,l),px+2,py-1);
		var t6 = new HotSpot(GetTile(px+2,py,l),px+2,py);
		return [t1,t2,t3,t4,t5,t6];
	}
	if (d == "west")
	{
		var t1 = new HotSpot(GetTile(px-1,py,l),px-1,py);
		var t2 = new HotSpot(GetTile(px-1,py-1,l),px-1,py-1);
		var t3 = new HotSpot(GetTile(px,py+1,l),px,py+1);
		var t4 = new HotSpot(GetTile(px-1,py+1,l),px-1,py+1);
		var t5 = new HotSpot(GetTile(px-2,py-1,l),px-2,py-1);
		var t6 = new HotSpot(GetTile(px-2,py,l),px-2,py);
		return [t1,t2,t3,t4,t5,t6];
	}
}

/*
	Is used in the update script. It checks to see if you attacked
	near tiles that are cutable. IE: grass, or bushes.
*/
g_CL = 0;
function Cut()
{
	if (GetPersonValue("you","attack") && GetPersonValue("you","frame") == 2)
	{
		var Hotspots = CreateHotSpots(1);
		for(var i = 0; i < Hotspots.length; ++i)
		{
			var TileName = GetTileName(Hotspots[i].tile);
			if (TileName == "bush")
			{
				PlaySound(Bushcut,200);
				SetTile(Hotspots[i].x,Hotspots[i].y,1,0); // the bush
				SetTile(Hotspots[i].x,Hotspots[i].y,2,0); // the obstruction
				CreatePerson("Leaf" + g_CL,"Leaves.rss",true);
				SetPersonXYFloat("Leaf" + g_CL,Hotspots[i].x*16+8,Hotspots[i].y*16+8);
				SetPersonLayer("Leaf" + g_CL,1);
				Animate("Leaf" + g_CL,"fall");
				g_CL++;
			}
			if (TileName == "grass" || TileName == "grassS")
			{
				PlaySound(Bushcut,200);
				SetTile(Hotspots[i].x,Hotspots[i].y,1,0); // the grass tile
			}
			for(var j = 0; j < BattleEnemies.length; ++j)
			{
				with(BattleEnemies[j])
				{
					if (x > Hotspots[i].x*16 && y > Hotspots[i].y*16 && x < Hotspots[i].x*16+16 && y < Hotspots[i].y*16+16)
					{	
						if (!death)
						{
							damageEnemy(Math.round(Player.ticks/Player.maxTicks*Player.atk));
							Player.ticks = 0;
							BounceBack(name);
						}
					}
				}
			}
		}
	}
}